<?php
/**
 * Page Template
 *
 * @package templateSystem
 * @copyright Copyright 2003-2005 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: tpl_reviews_default.php 2905 2006-01-28 01:25:36Z birdbrain $
 */
?>
<div class="centerColumn" id="reviewsDefault">

<h1 id="reviewsDefaultHeading"><?php echo $breadcrumb->last();  ?></h1>

<?php
  if ($reviews_split->number_of_rows > 0) {
    if ((PREV_NEXT_BAR_LOCATION == '1') || (PREV_NEXT_BAR_LOCATION == '3')) {
?>
<div id="reviewsDefaultListingTopNumber" class="navSplitPagesResult"><?php echo $reviews_split->display_count(TEXT_DISPLAY_NUMBER_OF_REVIEWS); ?></div>

<div id="reviewsDefaultListingTopLinks" data-role="controlgroup" data-type="horizontal" class="text-center"><?php echo TEXT_RESULT_PAGE . ' ' . $reviews_split->display_links(MAX_DISPLAY_PAGE_LINKS, zen_get_all_get_params(array('page', 'info', 'main_page'))); ?></div>

<?php
    }

    $reviews = $db->Execute($reviews_split->sql_query);
    while (!$reviews->EOF) {
?>
<hr />

    <div class="rwd-grid-a">

        <div class="ui-block-a">
            <?php echo '<a href="' . zen_href_link(FILENAME_PRODUCT_REVIEWS_INFO, 'products_id=' . $reviews->fields['products_id'] . '&reviews_id=' . $reviews->fields['reviews_id']) . '">' . jqm_image(DIR_WS_IMAGES . $reviews->fields['products_image'], $reviews->fields['products_name'], SMALL_IMAGE_WIDTH, SMALL_IMAGE_HEIGHT) . '</a>'; ?>
        </div>

        <div class="ui-block-b">
			<div class="ui-grid-a">
				<div class="ui-block-b">
					<?php echo '<a href="' . zen_href_link(FILENAME_PRODUCT_REVIEWS_INFO, 'products_id=' . $reviews->fields['products_id'] . '&reviews_id=' . $reviews->fields['reviews_id']) . '"' . jqm_button_widget(ANCHOR_BTN_CORNERS,'','',ANCHOR_BTN_SHADOW,false,ANCHOR_BTN_THEME,true,false,false,false) . '">' . BUTTON_READ_REVIEWS_ALT . '</a>'; ?>
				</div>
				<div class="ui-block-b">
					<?php echo '<a href="' . zen_href_link(zen_get_info_page($reviews->fields['products_id']), 'products_id=' . $reviews->fields['products_id']) . '"' . jqm_button_widget(ANCHOR_BTN_CORNERS,'','',ANCHOR_BTN_SHADOW,false,ANCHOR_BTN_THEME,true,false,false,false) . '">' . BUTTON_GOTO_PROD_DETAILS_ALT . '</a>'; ?>
				</div>
			</div>
        </div>
		<div class="clearfix"></div>
    </div>


<h2><?php echo $reviews->fields['products_name']; ?></h2>

<div class="rating-stars">
<?php
	$stars_possible = 5;
	$total_stars = $reviews->fields['reviews_rating'];
	$remaining_stars = ($stars_possible - $total_stars);

	for ($i = 1; $i <= $total_stars; $i++) {
	    echo '<span class="ion-ios-star"></span>';
	}

	for ($i = 1; $i <= $remaining_stars; $i++) {
	    echo '<span class="ion-ios-star-outline"></span>';
	}
?>
</div>

<div class="content"><?php echo zen_break_string(nl2br(zen_output_string_protected(stripslashes($reviews->fields['reviews_text']))), 60, '-<br />') . ((strlen($reviews->fields['reviews_text']) >= 100) ? '...' : ''); ?></div>

<div class="bold"><?php echo sprintf(TEXT_REVIEW_DATE_ADDED, zen_date_short($reviews->fields['date_added'])); ?>&nbsp;<?php echo sprintf(TEXT_REVIEW_BY, zen_output_string_protected($reviews->fields['customers_name'])); ?></div>
<br class="clearBoth" />
<?php
      $reviews->MoveNext();
    }
?>
<?php
  } else {
?>
<div id="reviewsDefaultNoReviews" class="content"><?php echo TEXT_NO_REVIEWS; ?></div>
<?php
  }
?>
<?php
  if (($reviews_split->number_of_rows > 0) && ((PREV_NEXT_BAR_LOCATION == '2') || (PREV_NEXT_BAR_LOCATION == '3'))) {
?>
<hr />
<div id="reviewsDefaultListingBottomNumber" class="navSplitPagesResult"><?php echo $reviews_split->display_count(TEXT_DISPLAY_NUMBER_OF_REVIEWS); ?></div>

<div id="reviewsDefaultListingBottomLinks" data-role="controlgroup" data-type="horizontal" class="text-center"><?php echo TEXT_RESULT_PAGE . ' ' . $reviews_split->display_links(MAX_DISPLAY_PAGE_LINKS, zen_get_all_get_params(array('page', 'info', 'main_page'))); ?></div>
<br class="clearBoth" />
<?php
  }
?>

</div>
