<?php
/**
 * Module Template
 *
 * @package templateSystem
 * @copyright Copyright 2003-2007 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: tpl_modules_upcoming_products.php 6422 2007-05-31 00:51:40Z ajeh $
 */
?>
<!-- bof: upcoming_products -->

<h2><?php echo TABLE_HEADING_UPCOMING_PRODUCTS; ?></h2>
<table data-role="table" data-mode="reflow" id="upcomingProductsTable" class="ui-responsive" summary="<?php echo SUMMARY_TABLE_UPCOMING_PRODUCTS; ?>">
<caption><?php echo CAPTION_UPCOMING_PRODUCTS; ?></caption>
<thead>
  <tr>
    <th data-priority="persist" id="upProductsHeading"><?php echo TABLE_HEADING_PRODUCTS; ?></th>
    <th data-priority="1" id="upDateHeading"><?php echo TABLE_HEADING_DATE_EXPECTED; ?></th>
  </tr>
</thead>
<tbody>
<?php
    for($i=0, $row=0; $i < sizeof($expectedItems); $i++, $row++) {
      $rowClass = (($row / 2) == floor($row / 2)) ? "rowEven" : "rowOdd";
      echo '  <tr>' . "\n";
      echo '    <td ><a href="' . zen_href_link(zen_get_info_page($expectedItems[$i]['products_id']), 'cPath=' . $productsInCategory[$expectedItems[$i]['products_id']] . '&products_id=' . $expectedItems[$i]['products_id']) . '">' . $expectedItems[$i]['products_name'] . '</a></td>' . "\n";
      echo '    <td >' . zen_date_short($expectedItems[$i]['date_expected']) . '</td>' . "\n";
      echo '  </tr>' . "\n";
    }
?>
</tbody>
</table>

<!-- eof: upcoming_products -->
