<?php
/**
 * Module Template - categories_tabs
 *
 * Template stub used to display categories-tabs output
 *
 * @package templateSystem
 * @copyright Copyright 2003-2005 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: tpl_modules_categories_tabs.php 3395 2006-04-08 21:13:00Z ajeh $
 */

  include(DIR_WS_MODULES . zen_get_module_directory(FILENAME_CATEGORIES_TABS));
  include(DIR_WS_MODULES . zen_get_module_directory('ezpages_bar_header.php'));


	echo '<aside data-role="panel" id="navPanel" data-position="left" data-display="push" data-theme="' . NAV_PANEL_THEME . '">';

if (sizeof($links_list) >= 1) {
	echo '<ul data-role="listview" class="ui-nodisc-icon ui-alt-icon">';
	echo '<li><a href="index.php/" data-direction="reverse" class="ui-icon-home">Home</a></li>';


if (((NAV_MAIN_LOCATION == '1') or (NAV_MAIN_LOCATION == '2')) or (($detect->isTablet()) and ((NAV_MAIN_LOCATION == '4') or (NAV_MAIN_LOCATION == '5')))) {
	if ($_SESSION['customer_id']) {
		echo '<li><a href="' . zen_href_link(FILENAME_LOGOFF, '', 'SSL') . '" class="ui-icon-logoff">' . HEADER_TITLE_LOGOFF . '</a></li>';
		echo '<li><a href="' . zen_href_link(FILENAME_ACCOUNT, '', 'SSL') . '" class="ui-icon-my-account">' . HEADER_TITLE_MY_ACCOUNT . '</a></li>';
	} else {
		if (STORE_STATUS == '0') {
			echo '<li><a href="' . zen_href_link(FILENAME_LOGIN, '', 'SSL') . '" class="ui-icon-login">' . HEADER_TITLE_LOGIN . '</a></li>';
		}
	}
	if ($_SESSION['cart']->count_contents() != 0) {
		echo '<li><a href="' . zen_href_link(FILENAME_SHOPPING_CART, '', 'NONSSL') . '" class="ui-icon-shopping-cart">' . HEADER_TITLE_CART_CONTENTS . '</a></li>';
		echo '<li><a href="' . zen_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL') . '" class="ui-icon-panel-checkout">' . HEADER_TITLE_CHECKOUT . '</a></li>';
	}
}

	if ((STORE_OWNER_EMAIL_ADDRESS != '') && ((EMAIL_CONTACT_LINKS == 'both') || (EMAIL_CONTACT_LINKS == 'email'))) {
		echo '<li><a href="mailto:' . STORE_OWNER_EMAIL_ADDRESS . '" class="ui-icon-email-us">' . EMAIL_US_TEXT . '</a></li>';
	}

	if ((EMAIL_CONTACT_LINKS == 'both') || (EMAIL_CONTACT_LINKS == 'contact')) {
		echo '<li><a href="' . zen_href_link(FILENAME_CONTACT_US, '', 'SSL') . '" class="ui-icon-contact-us">' . BOX_INFORMATION_CONTACT . '</a></li>';
	}

	if (STORE_TELEPHONE_CUSTSERVICE != '') {
	    echo '<li><a href="tel:' . STORE_TELEPHONE_CUSTSERVICE . '" class="ui-icon-callus">' . CALL_US_TEXT . '</a></li>';
	}

	if (FIND_US_ADDRESS != '') {
		$find_us_link = ($detect->isiOS()) ? 'http://maps.apple.com/?q=' : 'https://maps.google.com/maps?q=';
		echo '<li><a href="' . $find_us_link . FIND_US_ADDRESS . '" target="_blank" data-ajax="false" class="ui-icon-findus">' . FIND_US_TEXT . '</a></li>';
	}

	echo '<li data-role="list-divider">' . NAV_PANEL_CATEGORIES_LIST_DIVIDER . '</li>';

	$categories_tab_query = "SELECT c.categories_id, cd.categories_name FROM ".TABLE_CATEGORIES." c, ".TABLE_CATEGORIES_DESCRIPTION . " cd WHERE c.categories_id=cd.categories_id AND c.parent_id= '0' AND cd.language_id='" . (int)$_SESSION['languages_id'] . "' AND c.categories_status='1' ORDER BY c.sort_order, cd.categories_name;";
	$categories_tab = $db->Execute($categories_tab_query);

	while (!$categories_tab->EOF) {
	// currently selected category
		$subcategories_tab_query="SELECT c.categories_id, cd.categories_name FROM ".TABLE_CATEGORIES." c, ".TABLE_CATEGORIES_DESCRIPTION . " cd WHERE c.categories_id=cd.categories_id AND c.parent_id= '".(int)$categories_tab->fields['categories_id']."' AND cd.language_id='" . (int)$_SESSION['languages_id'] . "' AND c.categories_status='1' ORDER BY c.sort_order, cd.categories_name;";
		$subcategories_tab=$db->Execute($subcategories_tab_query);
		if((int)$cPath == $categories_tab->fields['categories_id'])
		{	
			echo '<li>'.$categories_tab->fields['categories_name'].'';
		}
		elseif($subcategories_tab->RecordCount()>0)
		{	
			echo '<li data-role="collapsible" data-collapsed-icon="carat-d" data-expanded-icon="carat-u" data-iconpos="right" data-inset="false"><h3>' . $categories_tab->fields['categories_name'] . '</h3>';
		}
		else
		{
			$cPath_flat = "cPath=".zen_get_generated_category_path_rev($categories_tab->fields['categories_id']);
			echo '<li>'.'<a href="' . zen_href_link(FILENAME_DEFAULT,$cPath_flat) . '">'.$categories_tab->fields['categories_name'].'</a></li>';
		}


		$subcategories_tab_query="SELECT c.categories_id, cd.categories_name FROM ".TABLE_CATEGORIES." c, ".TABLE_CATEGORIES_DESCRIPTION . " cd WHERE c.categories_id=cd.categories_id AND c.parent_id= '".(int)$categories_tab->fields['categories_id']."' AND cd.language_id='" . (int)$_SESSION['languages_id'] . "' AND c.categories_status='1' ORDER BY c.sort_order, cd.categories_name;";
		$subcategories_tab=$db->Execute($subcategories_tab_query);
		if($subcategories_tab->RecordCount()>0) 	{
			echo '<ul data-role="listview">';
			while (!$subcategories_tab->EOF) {
				$cPath_new = "cPath=".zen_get_generated_category_path_rev($subcategories_tab->fields['categories_id']);
				echo '<li>'.'<a href="' . zen_href_link(FILENAME_DEFAULT, $cPath_new) . '">'.$subcategories_tab->fields['categories_name'].'</a></li>';
				$subcategories_tab->MoveNext();
			}
			echo '</ul>';
		}
		/*$products_tab_query="SELECT p.`products_id`, pd.`products_name`, pd.`language_id` FROM ".TABLE_PRODUCTS." p, ".TABLE_PRODUCTS_DESCRIPTION." pd WHERE p.`master_categories_id`='".(int)$categories_tab->fields['categories_id']."' AND p.`products_id`=pd.`products_id` AND p.products_status='1' AND pd.`language_id`='".(int)$_SESSION['languages_id']."' ORDER BY p.`products_sort_order`;";
		$products_tab=$db->Execute($products_tab_query);
		if($products_tab->RecordCount()>0) {
			echo '<ul data-role="listview">';
			while (!$products_tab->EOF) {
				$cPath_new=zen_get_path($categories->fields['categories_id']);
				$cPath_new=str_replace('=0_', '=', $cPath_new);
				echo '<li>'.'<a href="'.zen_href_link(zen_get_info_page($products_tab->fields['products_id']),$cPath_new. '&products_id=' . $products_tab->fields['products_id']) . '">'.$products_tab->fields['products_name'].'</a></li>';
				$products_tab->MoveNext();
			}
			echo '</ul>';
		}*/
		echo '</li>';
		$categories_tab->MoveNext();
	}
	echo '</ul>';
}

if (INFORMATION_SIDEBOX_ON_SIDE_PANEL == 'true') {
	echo '<div class="clearfix"></div>';
	unset($information);

	if (DEFINE_SHIPPINGINFO_STATUS <= 1) {
		$information[] = '<a href="' . zen_href_link(FILENAME_SHIPPING) . '">' . BOX_INFORMATION_SHIPPING . '</a>';
	}
	if (DEFINE_PRIVACY_STATUS <= 1) {
		$information[] = '<a href="' . zen_href_link(FILENAME_PRIVACY) . '">' . BOX_INFORMATION_PRIVACY . '</a>';
	}
	if (DEFINE_CONDITIONS_STATUS <= 1) {
		$information[] = '<a href="' . zen_href_link(FILENAME_CONDITIONS) . '">' . BOX_INFORMATION_CONDITIONS . '</a>';
	}
	if (DEFINE_CONTACT_US_STATUS <= 1) {
		$information[] = '<a href="' . zen_href_link(FILENAME_CONTACT_US, '', 'SSL') . '">' . BOX_INFORMATION_CONTACT . '</a>';
	}

	// Forum (phpBB) link:
	if ( (isset($phpBB->phpBB['db_installed_config']) && $phpBB->phpBB['db_installed_config']) && (isset($phpBB->phpBB['files_installed']) && $phpBB->phpBB['files_installed'])  && (PHPBB_LINKS_ENABLED=='true')) {
		$information[] = '<a href="' . zen_href_link($phpBB->phpBB['phpbb_url'] . FILENAME_BB_INDEX, '', 'NONSSL', false, '', true) . '" target="_blank">' . BOX_BBINDEX . '</a>';
	// or: $phpBB->phpBB['phpbb_url'] . FILENAME_BB_INDEX
	// or: str_replace(str_replace(DIR_WS_CATALOG, '', DIR_FS_CATALOG), '', DIR_WS_PHPBB)
	}

	if (DEFINE_SITE_MAP_STATUS <= 1) {
		$information[] = '<a href="' . zen_href_link(FILENAME_SITE_MAP) . '">' . BOX_INFORMATION_SITE_MAP . '</a>';
	}

	// only show GV FAQ when installed
	if (MODULE_ORDER_TOTAL_GV_STATUS == 'true') {
		$information[] = '<a href="' . zen_href_link(FILENAME_GV_FAQ) . '">' . BOX_INFORMATION_GV . '</a>';
	}
	// only show Discount Coupon FAQ when installed
	if (DEFINE_DISCOUNT_COUPON_STATUS <= 1 && MODULE_ORDER_TOTAL_COUPON_STATUS == 'true') {
		$information[] = '<a href="' . zen_href_link(FILENAME_DISCOUNT_COUPON) . '">' . BOX_INFORMATION_DISCOUNT_COUPONS . '</a>';
	}

	if (SHOW_NEWSLETTER_UNSUBSCRIBE_LINK == 'true') {
		$information[] = '<a href="' . zen_href_link(FILENAME_UNSUBSCRIBE) . '">' . BOX_INFORMATION_UNSUBSCRIBE . '</a>';
	}

	echo '<ul id="information-listview" data-role="listview" class="ui-nodisc-icon ui-alt-icon">';
	echo '<li data-role="list-divider">' . BOX_HEADING_INFORMATION . '</li>';
	for ($i=0; $i<sizeof($information); $i++) {
		echo '<li>' . $information[$i] . '</li>' . "\n";
	}

if (sizeof($var_linksList) >= 1) {
	for ($i=1, $n=sizeof($var_linksList); $i<=$n; $i++) {
		echo '<li><a href="' . $var_linksList[$i]['link'] . '">' . $var_linksList[$i]['name'] . '</a></li>' . "\n";
	}
}



	echo '</ul>' .  "\n";
}









	echo '</aside>';

?>