<?php
/**
 * Page Template
 *
 * Loaded automatically by index.php?main_page=advanced_search.<br />
 * Displays options fields upon which a product search will be run
 *
 * @package templateSystem
 * @copyright Copyright 2003-2011 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: tpl_advanced_search_default.php 18695 2011-05-04 05:24:19Z drbyte $
 */
?>
<div class="centerColumn" id="advSearchDefault">

<?php echo zen_draw_form('advanced_search', zen_href_link(FILENAME_ADVANCED_SEARCH_RESULT, '', $request_type, false), 'get', 'onsubmit="return check_form(this);"') . zen_hide_session_id(); ?>
<?php echo zen_draw_hidden_field('main_page', FILENAME_ADVANCED_SEARCH_RESULT); ?>

<h1 id="advSearchDefaultHeading"><?php echo HEADING_TITLE_1; ?></h1>

<?php if ($messageStack->size('search') > 0) echo $messageStack->output('search'); ?>

<fieldset>
<legend><?php echo HEADING_SEARCH_CRITERIA; ?></legend>

<div class="pull-right">

	<a href="#searchHelp" data-rel="popup" data-transition="pop" data-position-to="window"><?php echo TEXT_SEARCH_HELP_LINK; ?></a>

	<div data-role="popup" id="searchHelp" class="ui-content" style="max-width:380px">
	    <a href="#" data-rel="back" class="ui-btn ui-corner-all ui-shadow ui-btn-a ui-icon-delete ui-btn-icon-notext ui-btn-right">Close</a>

	    <?php echo TEXT_SEARCH_HELP; ?>
	</div>

</div>
<br class="clearBoth" />
    <div class="text-center"><?php echo zen_draw_input_field('keyword', $sData['keyword'], 'onfocus="RemoveFormatString(this, \'' . KEYWORD_FORMAT_STRING . '\')"'); ?></div>


<div class="ui-field-contain">
	<label class="checkboxLabel" for="search-in-description"><?php echo TEXT_SEARCH_IN_DESCRIPTION; ?></label>
	<?php echo zen_draw_checkbox_field('search_in_description', '1', $sData['search_in_description'], 'id="search-in-description"'); ?>
</div>





<br class="clearBoth" />
</fieldset>

    <div class="rwd-grid-b">
        <div class="ui-block-b">
			    <h3><?php echo ENTRY_CATEGORIES; ?></h3>
			    <?php echo zen_draw_pull_down_menu('categories_id', zen_get_categories(array(array('id' => '', 'text' => TEXT_ALL_CATEGORIES)), '0' ,'', '1'), $sData['categories_id']); ?>
			<?php echo zen_draw_checkbox_field('inc_subcat', '1', $sData['inc_subcat'], 'id="inc-subcat"'); ?><label class="checkboxLabel" for="inc-subcat"><?php echo ENTRY_INCLUDE_SUBCATEGORIES; ?></label>
        </div>

        <div class="ui-block-b">
			    <h3><?php echo ENTRY_MANUFACTURERS; ?></h3>
			    <?php echo zen_draw_pull_down_menu('manufacturers_id', zen_get_manufacturers(array(array('id' => '', 'text' => TEXT_ALL_MANUFACTURERS)), PRODUCTS_MANUFACTURERS_STATUS), $sData['manufacturers_id']); ?>
        </div>
    </div>

    <div class="clearfix"></div>

<br class="clearBoth" />

<div class="search-input-fields rwd-grid-b">
    <div class="ui-block-b">
		<h3><?php echo ENTRY_PRICE_RANGE; ?></h3>
		<div class="ui-field-contain">
		    <label><?php echo ENTRY_PRICE_FROM; ?></label>
		    <?php echo zen_draw_input_field('pfrom', $sData['pfrom']); ?>
		</div>
		<div class="ui-field-contain">
		    <label><?php echo ENTRY_PRICE_TO; ?></label>
		    <?php echo zen_draw_input_field('pto', $sData['pto']); ?>
		</div>
    </div>

    <div class="ui-block-b">
		<h3><?php echo ENTRY_DATE_RANGE; ?></h3>
		<div class="ui-field-contain">
		    <label><?php echo ENTRY_DATE_FROM; ?></label>
		    <?php echo jqm_date_field('dfrom', $sData['dfrom'], 'onfocus="RemoveFormatString(this, \'' . DOB_FORMAT_STRING . '\')"'); ?>
		</div>
		<div class="ui-field-contain">
		    <label><?php echo ENTRY_DATE_TO; ?></label>
		    <?php echo jqm_date_field('dto', $sData['dto'], 'onfocus="RemoveFormatString(this, \'' . DOB_FORMAT_STRING . '\')"'); ?>
		</div>
    </div>
</div>

<div class="button-row ui-grid-a">
    <div class="ui-block-a">
		<?php echo jqm_back_link() . jqm_button_widget(ANCHOR_BTN_CORNERS,'','',ANCHOR_BTN_SHADOW,false,ANCHOR_BTN_THEME,true,false,false,false) . '">' . BUTTON_BACK_ALT . '</a>'; ?>
    </div>

    <div class="ui-block-b">
		<?php echo jqm_submit_button(BUTTON_IMAGE_SEARCH, BUTTON_SEARCH_ALT); ?>
    </div>
</div>


</form>
</div>