<?php
/**
 * Page Template
 *
 * Loaded automatically by index.php?main_page=account_password.<br />
 * Allows customer to change their password
 *
 * @package templateSystem
 * @copyright Copyright 2003-2014 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: tpl_account_password_default.php 2896 2006-01-26 19:10:56Z birdbrain $
 */
?>
<div class="centerColumn" id="accountPassword">
<?php echo zen_draw_form('account_password', zen_href_link(FILENAME_ACCOUNT_PASSWORD, '', 'SSL'), 'post', 'onsubmit="return check_form(account_password);"') . zen_draw_hidden_field('action', 'process'); ?>

<fieldset>
<legend><?php echo HEADING_TITLE; ?></legend>
<div class="alert forward"><?php echo FORM_REQUIRED_INFORMATION; ?></div>
<br class="clearBoth" />

<?php if ($messageStack->size('account_password') > 0) echo $messageStack->output('account_password'); ?>

<div class="ui-field-contain">
	<label class="inputLabel" for="password-current"><?php echo ENTRY_PASSWORD_CURRENT . (zen_not_null(ENTRY_PASSWORD_CURRENT_TEXT) ? '<span class="alert">' . ENTRY_PASSWORD_CURRENT_TEXT . '</span>': ''); ?></label>
	<?php echo zen_draw_password_field('password_current','','id="password-current" autocomplete="off"'); ?>
</div>

<div class="ui-field-contain">
	<label class="inputLabel" for="password-new"><?php echo ENTRY_PASSWORD_NEW . (zen_not_null(ENTRY_PASSWORD_NEW_TEXT) ? '<span class="alert">' . ENTRY_PASSWORD_NEW_TEXT . '</span>': ''); ?></label>
	<?php echo zen_draw_password_field('password_new','','id="password-new" autocomplete="off"'); ?>
</div>

<div class="ui-field-contain">
	<label class="inputLabel" for="password-confirm"><?php echo ENTRY_PASSWORD_CONFIRMATION . (zen_not_null(ENTRY_PASSWORD_CONFIRMATION_TEXT) ? '<span class="alert">' . ENTRY_PASSWORD_CONFIRMATION_TEXT . '</span>': ''); ?></label>
	<?php echo zen_draw_password_field('password_confirmation','','id="password-confirm" autocomplete="off"'); ?>
</div>

</fieldset>

    <div class="button-row ui-grid-a">
        <div class="ui-block-a">
			<?php echo '<a href="' . zen_href_link(FILENAME_ACCOUNT, '', 'SSL') . '"' . jqm_button_widget(ANCHOR_BTN_CORNERS,'','',ANCHOR_BTN_SHADOW,false,ANCHOR_BTN_THEME,true,false,false,false) . '" data-direction="reverse">' . BUTTON_BACK_ALT . '</a>'; ?>
        </div>
        <div class="ui-block-b">
	        <?php echo jqm_submit_button(BUTTON_IMAGE_SUBMIT, BUTTON_SUBMIT_ALT); ?>
        </div>
    </div>




</form>
</div>
