<?php
/**
 * Common Template - tpl_header.php
 *
 * this file can be copied to /templates/your_template_dir/pagename<br />
 * example: to override the privacy page<br />
 * make a directory /templates/my_template/privacy<br />
 * copy /templates/templates_defaults/common/tpl_footer.php to /templates/my_template/privacy/tpl_header.php<br />
 * to override the global settings and turn off the footer un-comment the following line:<br />
 * <br />
 * $flag_disable_header = true;<br />
 *
 * @package templateSystem
 * @copyright Copyright 2003-2012 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version GIT: $Id: Author: Ian Wilson  Tue Aug 14 14:56:11 2012 +0100 Modified in v1.5.1 $
 */
?>
<link rel="stylesheet" href="http://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
<?php
  // Display all header alerts via messageStack:
  if ($messageStack->size('header') > 0) {
    echo $messageStack->output('header');
  }
  if (isset($_GET['error_message']) && zen_not_null($_GET['error_message'])) {
  echo htmlspecialchars(urldecode($_GET['error_message']), ENT_COMPAT, CHARSET, TRUE);
  }
  if (isset($_GET['info_message']) && zen_not_null($_GET['info_message'])) {
   echo htmlspecialchars($_GET['info_message'], ENT_COMPAT, CHARSET, TRUE);
} else {

}
?>

<?php
if (!isset($flag_disable_header) || !$flag_disable_header) {
?>

<?php
	if ( $detect->isiOS() && (FIXED_HEADER == 'true') ) {
		$fixed_header = ' data-position="fixed" data-tap-toggle="false"';
	} elseif (!$detect->isiOS()) {
		$fixed_header = ' data-position="fixed" data-tap-toggle="false"';
	} else {
		$fixed_header = '';
	}
?>

<header data-role="header"<?php echo $fixed_header ?><?php echo (!$this_is_home_page) ? 'data-add-back-btn="true"' : ''; ?> data-theme="<?php echo HEADER_THEME; ?>">

	<div class="header-left pull-left">
		<?php if ($this_is_home_page && ($detect->isTablet())) { ?>
		<div id="tablet-logo" style="height:30px"><?php echo '<a href="' . HTTP_SERVER . DIR_WS_CATALOG . 'index.php" data-direction="reverse">' . '<img src="' . HTTP_SERVER . DIR_WS_CATALOG  . DIR_WS_TEMPLATE . 'images/' . HEADER_LOGO_IMAGE . '" alt="' . HEADER_ALT_TEXT . '" />' . '</a>'; ?></div>
		<?php } ?>
		<?php echo header_buttons('#navPanel','ion-navicon', false, false, HEADER_BUTTON_MENU_TEXT); ?>
		<?php if ($detect->isTablet()) { ?>
		<?php if ($_SESSION['customer_id']) { ?>
		<?php echo header_buttons(zen_href_link(FILENAME_LOGOFF, '', 'SSL'),'ion-log-out', false, false, HEADER_BUTTON_LOGOFF_TEXT); ?>
		<?php echo header_buttons(zen_href_link(FILENAME_ACCOUNT, '', 'SSL'),'ion-person', false, false, HEADER_BUTTON_MEMBER_TEXT); ?>
		<?php
		      } else {
		        if (STORE_STATUS == '0') {
		?>
		<?php echo header_buttons(zen_href_link(FILENAME_LOGIN, '', 'SSL'),'ion-log-in', false, false, HEADER_BUTTON_LOGIN_TEXT); ?>
		<?php } } ?>
		<?php } ?>
	</div>

		<?php if ($detect->isTablet()) { ?>
		<?php require(DIR_WS_MODULES . 'sideboxes/mobizencart/search_header.php'); ?>
		<?php } else { ?>
		<div id="logo" style="height:2em ; width="20px"><?php echo '<a href="' . HTTP_SERVER . DIR_WS_CATALOG . 'index.php" data-direction="reverse">' . '<img src="' . HTTP_SERVER . DIR_WS_CATALOG  . DIR_WS_TEMPLATE . 'images/' . HEADER_LOGO_IMAGE . '" alt="' . HEADER_ALT_TEXT . '" style="max-width:40%" />' . '</a>'; ?></div>
		<?php } ?>

	<div class="header-right pull-right">
		<?php if ((!$this_is_home_page and (TOGGLE_SEARCH_BAR == '1')) or (TOGGLE_SEARCH_BAR == '2'))  { ?>
		<?php //echo jqm_image('includes/templates/mobizencart/buttons/english/mobi_search_hdr_buttono.png','Search','40px','',' id="search-box"');?>
		<?php echo header_buttons('#search-box','ion-ios-search', false, false, HEADER_BUTTON_MENU_TEXT); ?>
		<?php } ?>
		<?php if ($_SESSION['cart']->count_contents() != 0) { ?>
	    <?php echo '<a href="'.zen_href_link(FILENAME_SHOPPING_CART, '', 'NONSSL').'">'.jqm_image('includes/templates/mobizencart/buttons/english/mobi_cart_hdr_button.png','Shopping Cart','40px').'</a>'; ?>
	    <?php echo header_buttons(zen_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL'),'ion-arrow-right-a', false, false, HEADER_BUTTON_CHECKOUT_TEXT); ?>
	<?php } else { ?>
		<?php //echo '<a href="'.zen_href_link(FILENAME_SHOPPING_CART, '', 'NONSSL').'">'.jqm_image('includes/templates/mobizencart/buttons/english/mobi_cart_hdr_button.png','Shopping Cart','40px').'</a>'; ?>
		<?php echo header_buttons(zen_href_link(FILENAME_SHOPPING_CART, '', 'NONSSL'),'ion-ios-cart-outline', false, false, HEADER_BUTTON_CART_TEXT_EMPTY); ?>
		<?php } ?>
	</div>

	<div class="clearfix"></div>

	<?php if (!$detect->isTablet()) { ?>
		<?php if ((!$this_is_home_page and (TOGGLE_SEARCH_BAR == '1')) or (TOGGLE_SEARCH_BAR == '2'))  { ?>
			<div class="search-box">
				<?php require(DIR_WS_MODULES . 'sideboxes/mobizencart/search_header.php'); ?>
			</div>
		<?php } else { ?>
			<?php require(DIR_WS_MODULES . 'sideboxes/mobizencart/search_header.php'); ?>
		<?php } ?>
	<?php } ?>
</header>
<?php }
$covid_header_note = false;
if($covid_header_note) {
    echo '<div id="header-notice-static"><span id="covid19_notice_text"><span style="font-weight:bold">COVID-19 NOTICE:</span><br />Due to the State of Maryland mandatory closures our warehouse is temporarily closed.<br />We will continue to accept orders - all orders will be processed and shipped once the non-essential closure has been lifted.<br />Thank you for your understanding during this time.</span></div>';
} ?>