<?php
/**
 * Common Template
 *
 * outputs the html header. i,e, everything that comes before the \</head\> tag <br />
 *
 * @package templateSystem
 * @copyright Copyright 2003-2014 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version GIT: $Id: Author: DrByte  Jul 5 2014 Modified in v1.5.4 $
 */
/**
 * load the module for generating page meta-tags
 */
require(DIR_WS_MODULES . zen_get_module_directory('meta_tags.php'));
/**
 * output main page HEAD tag and related headers/meta-tags, etc
 */
?>
<!DOCTYPE html>
<html class="no-js">
    <head>
        <meta charset="utf-8">
        <title><?php echo META_TAG_TITLE; ?></title>
        <meta name="description" content="<?php echo META_TAG_DESCRIPTION; ?>" />
        <meta name="keywords" content="<?php echo META_TAG_KEYWORDS; ?>" />
        <meta name="HandheldFriendly" content="True">
        <meta name="MobileOptimized" content="320">
        <meta name="viewport" content="user-scalable=no, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, width=device-width, height=device-height, target-densitydpi=device-dpi, minimal-ui">
        <meta http-equiv="cleartype" content="on">
		<?php if (defined('ROBOTS_PAGES_TO_SKIP') && in_array($current_page_base,explode(",",constant('ROBOTS_PAGES_TO_SKIP'))) || $current_page_base=='down_for_maintenance' || $robotsNoIndex === true) { ?>
		<meta name="robots" content="noindex, nofollow" />
		<?php } ?>
        <link rel="apple-touch-icon-precomposed" sizes="144x144" href="<?php echo DIR_WS_TEMPLATES . $template_dir;?>/images/touch/apple-touch-icon-144x144-precomposed.png">
        <link rel="apple-touch-icon-precomposed" sizes="114x114" href="<?php echo DIR_WS_TEMPLATES . $template_dir;?>/images/touch/apple-touch-icon-114x114-precomposed.png">
        <link rel="apple-touch-icon-precomposed" sizes="72x72" href="<?php echo DIR_WS_TEMPLATES . $template_dir;?>/images/touch/apple-touch-icon-72x72-precomposed.png">
        <link rel="apple-touch-icon-precomposed" href="<?php echo DIR_WS_TEMPLATES . $template_dir;?>/images/touch/apple-touch-icon-57x57-precomposed.png">
		<?php if (defined('FAVICON')) { ?>
		<link rel="icon" href="<?php echo FAVICON; ?>" type="image/x-icon" />
        <link rel="shortcut icon" sizes="196x196" href="<?php echo DIR_WS_TEMPLATES . $template_dir;?>/images/touch/touch-icon-196x196.png">
        <link rel="shortcut icon" href="<?php echo DIR_WS_TEMPLATES . $template_dir;?>/images/touch/apple-touch-icon.png">
		<?php } //endif FAVICON ?>

        <meta name="msapplication-TileImage" content="<?php echo DIR_WS_TEMPLATES . $template_dir;?>/images/touch/apple-touch-icon-144x144-precomposed.png">
        <meta name="msapplication-TileColor" content="#222222">

		<base href="<?php echo (($request_type == 'SSL') ? HTTPS_SERVER . DIR_WS_HTTPS_CATALOG : HTTP_SERVER . DIR_WS_CATALOG ); ?>" />
		<?php if (isset($canonicalLink) && $canonicalLink != '') { ?>
		<link rel="canonical" href="<?php echo $canonicalLink; ?>" />
		<?php } ?>

        <meta name="mobile-web-app-capable" content="yes">

        <meta name="format-detection" content="telephone=no">
        <meta name="apple-mobile-web-app-capable" content="yes">
        <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
        <meta name="apple-mobile-web-app-title" content="<?php echo (MOBILE_WEB_APP_TITLE == '') ? STORE_NAME : MOBILE_WEB_APP_TITLE; ?>">

<?php
/**
* load the loader files
*/

if($RI_CJLoader->get('status') && (!isset($Ajax) || !$Ajax->status())){
	$RI_CJLoader->autoloadLoaders();
	$RI_CJLoader->loadCssJsFiles();
	$files = $RI_CJLoader->header();

	foreach($files['css'] as $file)
		if($file['include']) {
      include($file['src']);
    } else if (!$RI_CJLoader->get('minify_css') || $file['external']) {
      echo '<link rel="stylesheet" type="text/css" href="'.$file['src'].'" />'."\n";
    } else {
      echo '<link rel="stylesheet" type="text/css" href="min/?f='.$file['src'].'&amp;'.$RI_CJLoader->get('minify_time').'" />'."\n";
    }

	foreach($files['jscript'] as $file)
		if($file['include']) {
      include($file['src']);
    } else if(!$RI_CJLoader->get('minify_js') || $file['external']) {
      echo '<script src="'.$file['src'].'"></script>'."\n";
    } else {
      echo '<script src="min/?f='.$file['src'].'&amp;'.$RI_CJLoader->get('minify_time').'"></script>'."\n";
    }
}
// DEBUG: echo '<!-- I SEE cat: ' . $current_category_id . ' || vs cpath: ' . $cPath . ' || page: ' . $current_page . ' || template: ' . $current_template . ' || main = ' . ($this_is_home_page ? 'YES' : 'NO') . ' -->';
?>
	<script src="<?php echo DIR_WS_TEMPLATES . $template_dir;?>/jscript/vendor/modernizr-2.7.1.min.js"></script>
</head>
<?php // NOTE: Blank line following is intended: ?>

