<?php

    /* NOTICE: This file shouldn't containts ONLYFOR tags!!! */

    ini_set('display_errors', true);
    error_reporting(E_ALL & ~E_NOTICE & ~E_DEPRECATED);

    function magictoolboxGetThumb($img, $type, $options, $pid = null) {
        require_once(dirname(__FILE__).'/magictoolbox.imagehelper.class.php');
        $imagehelper = new MagicToolboxImageHelperClass(DIR_FS_CATALOG, '/'.DIR_WS_IMAGES.'magictoolbox_cache', $options);
        return preg_replace('/^\//is', '', $imagehelper->create('/'.$img, $type, $pid));
    }

    function magictoolboxLoadModule($name) {
        if(!isset($GLOBALS['magictoolbox'])) $GLOBALS['magictoolbox'] = array();
        if(!isset($GLOBALS['magictoolbox'][$name])) {
            /* load module */
            require_once(dirname(__FILE__).'/'.strtolower($name).'.module.core.class.php');
            $className = $name.'ModuleCoreClass';
            $mod = new $className;
            /* load params */
            $allParamsLoaded = true;
            foreach($mod->params->getArray() as $id => $param) {
                if($name == 'MagicZoomPlus' && ($id == 'disable-expand' || $id == 'disable-zoom')) continue;
                $value = @constant('ZEN_'.strtoupper($name).'_'.strtoupper($id));
                if($value !== NULL) $mod->params->set($id, $value);
                else $allParamsLoaded = false;
            }
            if(defined('MAGICTOOLBOX_MESSAGE_UNDER_IMAGES') && MAGICTOOLBOX_MESSAGE_UNDER_IMAGES != '') {
                $mod->params->set('message', MAGICTOOLBOX_MESSAGE_UNDER_IMAGES);
            }
            if(in_array(strtolower($name), array('magiczoom', 'magiczoomplus', 'magicthumb', 'magictouchplus'))) {
                if(defined('MAGICTOOLBOX_LOADING_MESSAGE') && MAGICTOOLBOX_LOADING_MESSAGE != '') {
                    $mod->params->set('loading-msg', MAGICTOOLBOX_LOADING_MESSAGE);
                }
            }
            if(strtolower($name) == 'magicslideshow' || strtolower($name) == 'magic360') {
                if(defined('MAGICTOOLBOX_LOADING_TEXT') && MAGICTOOLBOX_LOADING_TEXT != '') {
                    $mod->params->set('loading-text', MAGICTOOLBOX_LOADING_TEXT);
                }
            }
            if(strtolower($name) == 'magic360') {
                if(defined('MAGICTOOLBOX_HINT_TEXT') && MAGICTOOLBOX_HINT_TEXT != '') {
                    $mod->params->set('hint-text', MAGICTOOLBOX_HINT_TEXT);
                }
                if(defined('MAGICTOOLBOX_MOBILE_HINT_TEXT') && MAGICTOOLBOX_MOBILE_HINT_TEXT != '') {
                    $mod->params->set('mobile-hint-text', MAGICTOOLBOX_MOBILE_HINT_TEXT);
                }
            }
            //if($name == 'MagicSlideshow' || $name == 'MagicScroll') {
            //    $mod->params->set('link-to-product-page', 'yes');
            //}
            if($allParamsLoaded) $GLOBALS['magictoolbox'][$name] = & $mod;
        }
        return isset($mod) ? $mod : $GLOBALS['magictoolbox'][$name];
    }

    function magictoolboxGetImagePath($image, $pid = null) {

        //if(empty($image)) return '';

        //Image Handler 2, 3
        if(strpos($image, 'bmz_cache') !== false) {
            if($pid !== null) {
                global $db;
                $result = $db->Execute('SELECT products_image FROM products WHERE products_id = '.$pid);
                if(!$result->EOF) {
                    $image = $result->fields['products_image'];
                } else {
                    return $image;
                }
            } else {
                return $image;
            }
        }

        $image = str_replace(DIR_FS_CATALOG.DIR_WS_IMAGES, '', $image);
        $image = preg_replace('/^\/?'.preg_quote(DIR_WS_IMAGES,'/').'/is', '', $image);
        $info = pathinfo($image);
        if(intval(phpversion()) < 5 || !isset($info['filename'])) {
            $info['filename'] = basename($info['basename'], '.'.$info['extension']);
        }
        if($info['dirname'] == '.') $info['dirname'] = '';
        if(!empty($info['dirname'])) $info['dirname'] .= '/';
        $large_image = 'large/'.$info['dirname'].$info['filename'].IMAGE_SUFFIX_LARGE.'.'.$info['extension'];
        if(!file_exists(DIR_FS_CATALOG.DIR_WS_IMAGES.$large_image)) {
            $large_image = 'medium/'.$info['dirname'].$info['filename'].IMAGE_SUFFIX_MEDIUM.'.'.$info['extension'];
            if(!file_exists(DIR_FS_CATALOG.DIR_WS_IMAGES.$large_image)) {
                $large_image = $info['dirname'].$info['filename'].'.'.$info['extension'];
            }
        }
        return DIR_WS_IMAGES.$large_image;
    }

?>
