<?php

$detect = new Mobile_Detect;

	function jqm_submit_button($image, $alt = '', $parameters = '', $sec_class = '') {
		global $template, $current_page_base, $zco_notifier;
		$zco_notifier->notify('PAGE_OUTPUT_IMAGE_SUBMIT');
		//$jqm_submit_button = '<div class="text-right">';
		$jqm_submit_button .= '<input type="submit" value="' . zen_output_string($alt) . '"';
		$jqm_submit_button .= (SUBMIT_BTN_CORNERS == 'false') ? ' data-corners="false"' : '';
		$jqm_submit_button .= (SUBMIT_BTN_SHADOW == 'false') ? ' data-shadow="false"' : '';
		$jqm_submit_button .= ' data-theme="' . SUBMIT_BTN_THEME . '"';
		$jqm_submit_button .= (SUBMIT_BTN_MINI == 'true') ? ' data-mini="true"' : '';
		if (zen_not_null($parameters)) $jqm_submit_button .= ' ' . $parameters;
		$jqm_submit_button .= ' />';
		//$jqm_submit_button .= '</div>';

		return $jqm_submit_button;
	}
	function jqm_draw_form($name, $action, $method = 'post', $parameters = '') {
		$form = '<form name="' . zen_output_string($name) . '" action="' . zen_output_string($action) . '" method="' . zen_output_string($method) . '"';

		if (zen_not_null($parameters)) $form .= ' ' . $parameters;

		$form .= '>';
		if (strtolower($method) == 'post') $form .= '<input type="hidden" name="securityToken" value="' . $_SESSION['securityToken'] . '" />';
		return $form;
	}
	function jqm_noajax_form($name, $action, $method = 'post', $parameters = '') {
		$form = '<form name="' . zen_output_string($name) . '" action="' . zen_output_string($action) . '" method="' . zen_output_string($method) . '" data-ajax="false"';
		if (zen_not_null($parameters)) $form .= ' ' . $parameters;
		$form .= '>';
		if (strtolower($method) == 'post') $form .= '<input type="hidden" name="securityToken" value="' . $_SESSION['securityToken'] . '" />';
		return $form;
	}


		//Output a form input field
		  function zen_search_input_field($name, $value = '', $parameters = '', $type = 'search', $reinsert_value = true) {
		    $field = '<input type="' . zen_output_string($type) . '" name="' . zen_sanitize_string(zen_output_string($name)) . '"';
		    if ( (isset($GLOBALS[$name]) && is_string($GLOBALS[$name])) && ($reinsert_value == true) ) {
		      $field .= ' value="' . zen_output_string(stripslashes($GLOBALS[$name])) . '"';
		    } elseif (zen_not_null($value)) {
		      $field .= ' value="' . zen_output_string($value) . '"';
		    }

		    if (zen_not_null($parameters)) $field .= ' ' . $parameters;

		    $field .= ' />';

		    return $field;
		  }

		//Outputs a header button
		/*  "Back" button links from http://demos.jquerymobile.com/1.4.5/navigation-linking-pages/
			If you use the attribute data-rel="back" on an anchor, any clicks on that
			anchor will mimic the back button, going back one history entry and ignoring
			the anchor's default href. This is particularly useful when generating "back"
			buttons with JavaScript, such as a button to close a dialog.

			If you just want a reverse transition without actually going back in history,
			you should use the data-direction="reverse" attribute instead. Note: data-direction="reverse"
			is meant to simply run the backwards version of the transition that will run
			on that page change, while data-rel="back" makes the link functionally equivalent
			to the browser's back button and all the standard back button logic applies.
			Adding data-direction="reverse" to a link with data-rel="back" will not reverse
			the reversed page transition and produce the "normal" version of the transition. */

		//Anchor Buttons  *  sample: jqm_button_widget(true,'','',false,false,'a',false,true,false,true)
		function jqm_button_widget($corners, $icon, $position, $btn_shadow, $inline, $theme, $mini, $icon_shadow, $icon_disc, $alternate_icon) {
			$jqm_button_widget = ' class="ui-btn';
			$jqm_button_widget .= ($corners == true) ? ' ui-corner-all' : '';
			$jqm_button_widget .= ($icon != '') ? ' ui-icon-' . $icon : '' ;
			$jqm_button_widget .= ($position != '') ? ' ui-btn-icon-' . $position : '';
			$jqm_button_widget .= ($btn_shadow == true) ? ' ui-shadow' : '';
			$jqm_button_widget .= ($inline == true) ? ' ui-btn-inline' : '';
			$jqm_button_widget .= ($theme != '') ? ' ui-btn-' . $theme : '';
			$jqm_button_widget .= ($mini == true) ? ' ui-mini' : '';
			$jqm_button_widget .= ($icon_shadow == true) ? ' ui-shadow-icon' : '';
			$jqm_button_widget .= ($icon_disc == false) ? ' ui-nodisc-icon' : '';
			$jqm_button_widget .= ($alternate_icon == true) ? ' ui-alt-icon' : '';

			return $jqm_button_widget;
		}

		function header_buttons($href, $button_class, $back, $reverse, $link_text) {
			$button_text = '<a href="' . $href . '"';
			$button_text .= ($back == true) ? ' data-rel="back"' : '"';
			$button_text .= ($reverse == true) ? ' data-direction="reverse"' : '';
			$button_text .= ' class="ui-btn ' .  $button_class . ' ui-nodisc-icon ui-alt-icon ui-btn-icon-notext ui-corner-all"';
			$button_text .= '>' . $link_text . '</a>';

			echo $button_text;
		}

		//The HTML form submit button wrapper function  *  Outputs an icon only "submit" button in the selected language
		function jqm_icon_submit($image, $alt = '', $data_icon = '', $parameters = '', $sec_class = '') {
			global $template, $current_page_base, $zco_notifier;
			$zco_notifier->notify('PAGE_OUTPUT_IMAGE_SUBMIT');
			$image_submit = '<input type="submit" alt="' . zen_output_string($alt) . '"';
			$image_submit .= ' data-icon="' . $data_icon . '" data-iconpos="notext"';
			//if (zen_not_null($alt)) $image_submit .= ' title=" ' . zen_output_string($alt) . ' "';
			if (zen_not_null($parameters)) $image_submit .= ' ' . $parameters;
			$image_submit .= ' />';
			return $image_submit;
		}

		//Outputs the settings for an anchor button  *  Replaces zen_image_button
		function jqm_anchor_button($data_mini) {
			$jqm_anchor_button = ' class="ui-btn';
			$jqm_anchor_button .= (ANCHOR_BTN_CORNERS == 'true') ? ' ui-corner-all' : '';
			$jqm_anchor_button .= (ANCHOR_BTN_SHADOW == 'true') ? ' ui-shadow' : '';
			if ($data_mini == true) {
				if (SMALL_BUTTONS_ANCHOR_BTN_MINI == 'true') {
					$jqm_anchor_button .= ' ui-mini';
				} else {
					$jqm_anchor_button .= (ANCHOR_BTN_MINI == 'true') ? ' ui-mini' : '';
				}
			} else {
				$jqm_anchor_button .= (ANCHOR_BTN_MINI == 'true') ? ' ui-mini' : '';
			}
			$jqm_anchor_button .= ' ui-btn-' . ANCHOR_BTN_THEME;
			$jqm_anchor_button .= '"';
			return $jqm_anchor_button;
		}

		//Output a function button in the selected language
		function jqm_image_button($image, $alt = '', $parameters = '', $sec_class = '') {
			global $template, $current_page_base, $zco_notifier;
			$zco_notifier->notify('PAGE_OUTPUT_IMAGE_BUTTON');
			return $alt;
		}

		//Outputs add to cart input or select on listing pages
		function product_listing_add_to_cart($product_list) {
			if (ADD_TO_CART_QUANTITY_BOX == 'input') {
				$product_listing_add_to_cart = '<input type="number" pattern="[0-9]*" name="products_id[' . $$product_list . ']" value="0" />';
			} else {
			    $product_listing_add_to_cart = '<select class="add-to-cart-select" name="products_id[' . $product_list . ']" autocomplete="off" value="0">';
				    $select_option = 0;
				    while ($select_option <= ADD_TO_CART_SELECT_MAX):
				    	$product_listing_add_to_cart .= '<option value="' . $select_option . '">' . $select_option . '</option>';
				    $select_option++;
				    endwhile;
				$product_listing_add_to_cart .= '</select>';
			}
			return $product_listing_add_to_cart;
		}

		//Outputs add to cart input or select
		function product_info_add_to_cart($product_info, $product_min = '', $product_units = '') {
			if (ADD_TO_CART_QUANTITY_BOX == 'input') {
			$product_info_add_to_cart = '<input type="number" pattern="[0-9]*" name="cart_quantity" value="' . $product_info . '" />';
			} else {
			$product_info_add_to_cart = '<select name="cart_quantity" autocomplete="off" id="cart_quantity" value="' . $product_info . '">';
			    $select_option = $product_min;
				while ($select_option <= ADD_TO_CART_SELECT_MAX):
				switch(true)
				{
					case ($product_min == $select_option):
					case ( ($select_option % $product_units) === 0 && $select_option <= 20):
						//echo 'adding option'.$select_option.' / ' . $product_units . '='.$select_option % $product_units.'<br />';;
						$product_info_add_to_cart .= '<option value="' . $select_option . '">' . $select_option . '</option>';
					break;
					
					case ( ($select_option % 10 ) === 0 && ($select_option > 20 && $select_option <= 100) ):
						//echo 'adding option'.$select_option.' / ' . $product_units . '='.$select_option % $product_units.'<br />';;
						$product_info_add_to_cart .= '<option value="' . $select_option . '">' . $select_option . '</option>';
					break;
					
					case ( ($select_option % 50) === 0 && ($select_option > 100 && $select_option <= ADD_TO_CART_SELECT_MAX) ):
						//echo 'adding option'.$select_option.' / ' . $product_units . '='.$select_option % $product_units.'<br />';;
						$product_info_add_to_cart .= '<option value="' . $select_option . '">' . $select_option . '</option>';
					break;
				}
			    $select_option++;
			    endwhile;
			$product_info_add_to_cart .= '</select>';
			}
			return $product_info_add_to_cart;
		}

		//Output a form quantity field
		function jqm_quantity_field($name, $value = '', $parameters = 'pattern="[0-9]*"') {
			return zen_draw_input_field($name, $value, $parameters, 'number', true);
		}

		// Set back button
		function jqm_back_link($link_only = false) {
			if (sizeof($_SESSION['navigation']->path)-2 >= 0) {
			  $back = sizeof($_SESSION['navigation']->path)-2;
			  $link = zen_href_link($_SESSION['navigation']->path[$back]['page'], zen_array_to_string($_SESSION['navigation']->path[$back]['get'], array('action')), $_SESSION['navigation']->path[$back]['mode']);
			} else {
			  if (isset($_SERVER['HTTP_REFERER']) && preg_match("~^".HTTP_SERVER."~i", $_SERVER['HTTP_REFERER']) ) {
			    $link= $_SERVER['HTTP_REFERER'];
			  } else {
			    $link = zen_href_link(FILENAME_DEFAULT);
			  }
			  $_SESSION['navigation'] = new navigationHistory;
			}
			if ($link_only == true) {
			  return $link;
			} else {
			  return '<a href="' . $link . '" data-direction="reverse"';
			}
		}

		/* Output a form date field */
		function jqm_date_field($name, $value = '', $parameters = '', $type = 'text', $reinsert_value = true) {
			$type = (DATE_INPUT_FIELD == 'date') ? 'date': 'text';
			$field = '<input';
			$field .= ' type="' . zen_output_string($type) . '" name="' . zen_sanitize_string(zen_output_string($name)) . '"';
			$field .= (DATE_INPUT_FIELD == 'datebox') ? ' data-role="datebox" data-options=\'{"mode":"calbox", "useInlineBlind":true,"useFocus":true,"useButton":false, "overrideDateFormat":"'.DATE_FORMAT_SHORT.'"}\'': '';
			if ( (isset($GLOBALS[$name]) && is_string($GLOBALS[$name])) && ($reinsert_value == true) ) {
			  $field .= ' value="' . zen_output_string(stripslashes($GLOBALS[$name])) . '"';
			} elseif (zen_not_null($value)) {
			  $field .= ' value="' . zen_output_string($value) . '"';
			}
			if (zen_not_null($parameters)) $field .= ' ' . $parameters;
			$field .= ' />';
			return $field;
		}

		//Output an email field
		function jqm_email_field($name, $value = '', $parameters = '') {
			return zen_draw_input_field($name, $value, $parameters, 'email', true);
		}

		//Output a telephone field
		function jqm_tel_field($name, $value = '', $parameters = '') {
			return zen_draw_input_field($name, $value, $parameters, 'tel', true);
		}

		//Outputs the settings for an listviews
		function jqm_listview($listview_class, $parameters) {
			$jqm_listview = '<ul data-role="listview"';
			$jqm_listview .= (LISTVIEW_INSET == 'true') ? ' data-inset="true"' : '';
			$jqm_listview .= ' data-theme="' . LISTVIEW_DATA_THEME . '"';
			$jqm_listview .= ' data-divider-theme="' . LISTVIEW_DATA_DIVIDER_THEME . '"';
			$jqm_listview .= ' class="' .  $listview_class . '"';
			$jqm_listview .= ($parameters != '') ? ' ' . $parameters : '' ;
			$jqm_listview .= '>';

			return $jqm_listview;
		}



        /*
         * The HTML image wrapper function
         */
        function jqm_image($src, $alt = '', $width = '', $height = '', $parameters = '', $proportional = true) {
			global $template_dir, $zco_notifier;

            // soft clean the alt tag
            $alt = zen_clean_html($alt);

            // use old method on template images
            if (strstr($src, 'includes/templates') or strstr($src, 'includes/languages') or PROPORTIONAL_IMAGES_STATUS == '0') {
                return zen_image_OLD($src, $alt, $width, $height, $parameters);
            }

        //auto replace with defined missing image
            if ($src == DIR_WS_IMAGES and PRODUCTS_IMAGE_NO_IMAGE_STATUS == '1') {
                $src = DIR_WS_IMAGES . PRODUCTS_IMAGE_NO_IMAGE;
            }

            if ( (empty($src) || ($src == DIR_WS_IMAGES)) && (IMAGE_REQUIRED == 'false') ) {
                return false;
            }

            // if not in current template switch to template_default
            if (!file_exists($src)) {
                $src = str_replace(DIR_WS_TEMPLATES . $template_dir, DIR_WS_TEMPLATES . 'template_default', $src);
            }

            // hook for handle_image() function such as Image Handler etc
            if (function_exists('handle_image')) {
                $newimg = handle_image($src, $alt, $width, $height, $parameters);
                list($src, $alt, $width, $height, $parameters) = $newimg;
                $zco_notifier->notify('NOTIFY_HANDLE_IMAGE', array($newimg));
            }

            // Convert width/height to int for proper validation.
            // intval() used to support compatibility with plugins like image-handler
            $width = empty($width) ? $width : intval($width);
            $height = empty($height) ? $height : intval($height);
        // alt is added to the img tag even if it is null to prevent browsers from outputting
        // the image filename as default
            $image = '<img src="' . HTTP_SERVER . DIR_WS_CATALOG . zen_output_string($src) . '" alt="' . zen_output_string($alt) . '"';

            if (zen_not_null($alt)) {
                $image .= ' title=" ' . zen_output_string($alt) . ' "';
            }

            if ( ((CONFIG_CALCULATE_IMAGE_SIZE == 'true') && (empty($width) || empty($height))) ) {
                if ($image_size = @getimagesize($src)) {
                    if (empty($width) && zen_not_null($height)) {
                        $ratio = $height / $image_size[1];
                        $width = $image_size[0] * $ratio;
                    } elseif (zen_not_null($width) && empty($height)) {
                        $ratio = $width / $image_size[0];
                        $height = $image_size[1] * $ratio;
                    } elseif (empty($width) && empty($height)) {
                        $width = $image_size[0];
                        $height = $image_size[1];
                    }
                } elseif (IMAGE_REQUIRED == 'false') {
                    return false;
                }
            }


            if (zen_not_null($width) && zen_not_null($height) and file_exists($src)) {
        //      $image .= ' width="' . zen_output_string($width) . '" height="' . zen_output_string($height) . '"';
        // proportional images
                $image_size = @getimagesize($src);
                // fix division by zero error
                $ratio = ($image_size[0] != 0 ? $width / $image_size[0] : 1);
                if ($image_size[1]*$ratio > $height) {
                    $ratio = $height / $image_size[1];
                    $width = $image_size[0] * $ratio;
                } else {
                    $height = $image_size[1] * $ratio;
                }
        // only use proportional image when image is larger than proportional size
                if ($image_size[0] < $width and $image_size[1] < $height && $proportional) {
                    $image .= ' width="' . $image_size[0] . '" height="' . intval($image_size[1]) . '"';
                } else {
                    $image .= ' width="' . round($width) . '" height="' . round($height) . '"';
                }
            } else {
                // override on missing image to allow for proportional and required/not required
                if (IMAGE_REQUIRED == 'false') {
                    return false;
                } else if (substr($src, 0, 4) != 'http') {
                    $image .= ' width="' . intval(SMALL_IMAGE_WIDTH) . '" height="' . intval(SMALL_IMAGE_HEIGHT) . '"';
                }
            }

            // inject rollover class if one is defined. NOTE: This could end up with 2 "class" elements if $parameters contains "class" already.
            if (defined('IMAGE_ROLLOVER_CLASS') && IMAGE_ROLLOVER_CLASS != '') {
                $parameters .= (zen_not_null($parameters) ? ' ' : '') . 'class="rollover"';
            }
            // add $parameters to the tag output
            if (zen_not_null($parameters)) $image .= ' ' . $parameters;

            $image .= ' />';
            return $image;
        }

?>