<?php
/**
 * functions_jc.php
 * additional functions added by joe
 */


function jc_format_price($products_id) {
global $db;
$sql = 'select products_price, products_quantity_order_min from products where products_id = :products_id:';
$sql = $db->bindVars($sql, ':products_id:', $products_id, 'integer');
$result = $db->Execute($sql);
$min_qty = $result->fields['products_quantity_order_min'];
$dbprice = $result->fields['products_price'];
if ($dbprice < '1.000') {
$fprice = ($dbprice * 100) . '&cent;';}
else {
$fprice = '&#36;' . number_format($dbprice,2) ; }
return  $fprice. ', Min:' . $min_qty;
}
/////////////////////////////////////////////
//return list of holidays in the next 3 months
// return a list of customers (id & email address) who have the use_rt flag set, but have no templates
function find_upcoming_holidays(){
  global $db;
$today = date("yyyy/mm/dd");
$three_months_out = '';
  $sql = 'SELECT *
          FROM holidays
          WHERE holiday_date BETWEEN NOW() AND DATE_ADD(NOW(), INTERVAL 90 DAY)';
  $holidays = $db->Execute($sql);
$upcoming_holidays = array();
  while (!$holidays->EOF){
    $upcoming_holidays[] = $holidays->fields;
    $holidays->moveNext();
  }

  return $upcoming_holidays;
  }
function display_upcoming_holidays(){
  $displayh = '';
  $found_upcoming_holidays = find_upcoming_holidays();
  $displayh .= '<ul class="holiday_display">';
  foreach ($found_upcoming_holidays as $hol){
    $displayh .= '<li><span style="font-weight:bold">' . $hol['holiday_name'] . '</span><br />' . zen_date_long2($hol['holiday_date']) . '<br /><a href="index.php?main_page&#61;index&amp;cPath&#61;' . $hol['holiday_cat_id'] . '">View ' . $hol['holiday_name'] . '</a></li>';}
	$displayh .= '</ul>';
	/*$displayh .= '<span class="upcoming_holiday_display"><span style="font-weight:bold">' . $hol['holiday_name'] . '</span><span><br />' . zen_date_long2($hol['holiday_date']) . '</span><br /><span style="display:inline-table ; width:100% ; text-align:center ; font-size:.8em ; text-transform:uppercase ; color:#777"><a href="index.php?main_page&#61;index&amp;cPath&#61;' . $hol['holiday_cat_id'] . '">View ' . $hol['holiday_name'] . '</a></span></span>';
  }*/
  $displayh .= '<div class="upcoming_holiday_display2"><table><tr><td style="width:10% ; text-align:right"><a href="index.php?main_page=page_2"><img src="' . DIR_WS_TEMPLATE_IMAGES . 'zoom.png" alt="Calendar" /></a></td><td style="text-align:left ; padding-left:.2em ; font-size:.8em"><a href="index.php?main_page=page_2" id="header_links2">View complete Holiday list</a></td></tr></table></div>';
  if ($displayh == '') {
  $displayh = '123' ; }
  else {
  return $displayh ;}
}
function find_all_holidays(){
  global $db;
$today = date("yyyy/mm/dd");
$three_months_out = '';
  $sql = 'SELECT *
          FROM holidays
		  WHERE holiday_date > NOW()
          ORDER by holiday_date LIMIT 20';
  $holidays_all = $db->Execute($sql);
$all_holidays = array();
  while (!$holidays_all->EOF){
    $all_holidays[] = $holidays_all->fields;
    $holidays_all->moveNext();
  }

  return $all_holidays;
  }
function display_all_holidays(){
  $displayall = '';
  $found_all_holidays = find_all_holidays();
  
  foreach ($found_all_holidays as $hol_all){
    $displayall .= '<div class="holiday_wrapper"><a href="index.php?main_page=index&cPath=' . $hol_all['holiday_cat_id'] . '"><span class="hol_name">' . $hol_all['holiday_name'] . '</span><br /><br /><span class="hol_date">' . zen_date_long2($hol_all['holiday_date']) . '</span><br /><br /><span class="hol_link"><img src="includes/templates/cambridge_pro/buttons/english/button_search_header.gif" alt="View ' . $hol_all['holiday_name'] . ' Balloons" height="20px" style="vertical-align:middle" />View Balloons</a></span></div>';
	/*$displayall .= '<span class="upcoming_holiday_display"><span class="holiday_name">' . $hol_all['holiday_name'] . '</span><span><br />' . zen_date_long2($hol_all['holiday_date']) . '</span><span style="display:inline-table ; width:100% ; text-align:center ; font-size:.8em ; text-transform:uppercase ; color:#777"><a href="index.php?main_page=index&cPath=' . $hol_all['holiday_cat_id'] . '">View ' . $hol_all['holiday_name'] . '</a></span></span>';*/
  }
  $displayall .= '<br />' ;
  if ($displayall == '') {
  $displayall = '123' ; }
  else {
  return $displayall ;}
}

//eof holiday list
//WHERE holiday_date BETWEEN "2012/01/01" AND "2012/06/01"';
function zen_date_long2($raw_date) {
    if ( ($raw_date == '0001-01-01 00:00:00') || ($raw_date == '') ) return false;

    $year = (int)substr($raw_date, 0, 4);
    $month = (int)substr($raw_date, 5, 2);
    $day = (int)substr($raw_date, 8, 2);
    $hour = (int)substr($raw_date, 11, 2);
    $minute = (int)substr($raw_date, 14, 2);
    $second = (int)substr($raw_date, 17, 2);

    return strftime(DATE_FORMAT_LONG2, mktime($hour,$minute,$second,$month,$day,$year));
  }
function jc_get_customer_email($customer_id) {
global $db;
$sql = 'select customers_email_address from ' . TABLE_CUSTOMERS . ' where customers_id = :customer_id:';
$sql = $db->bindVars($sql, ':customer_id:', $customer_id, 'string');
$email = $db->Execute($sql);
return $email;}

function jc_get_index_slides(){
  global $db;
$today = date("yyyy/mm/dd");
$three_months_out = '';
  $sql = 'SELECT * FROM
          index_slides WHERE slides_status > 0 AND (slides_end > unix_timestamp() OR slides_end IS NULL) AND (slides_start <= unix_timestamp() OR slides_start IS NULL) ORDER BY slides_sort, RAND();';
  $slides_all = $db->Execute($sql);
$all_slides = array();
  while (!$slides_all->EOF){
    $all_slides[] = $slides_all->fields;
    $slides_all->moveNext();
  }
  return $all_slides;
}

function jc_get_discount_percentage($customer_id) {
	global $db;
	$group_query = "select customers_group_pricing from " . TABLE_CUSTOMERS . " where customers_id = '" . (int)$customer_id . "'";
	$group = $db->Execute($group_query);
	if($group->fields['customers_group_pricing'] > 0)
	{
		$discount_query = "select group_percentage FROM " . TABLE_GROUP_PRICING . " where group_id = '" . (int)$group->fields['customers_group_pricing'] . "'";
		$discount = $db->Execute($discount_query);	

	}
	if($discount->fields['group_percentage'] <= 0) { return false; }
	return $discount->fields['group_percentage'];
}

function jc_get_discount_group($customer_id) {
	global $db;
	$group_query = "select customers_group_pricing from " . TABLE_CUSTOMERS . " where customers_id = '" . (int)$customer_id . "'";
	$group = $db->Execute($group_query);
	if($group->fields['customers_group_pricing'] > 0)
	{
		return $group->fields['customers_group_pricing'];
	}
	else
	{
		return false;
	}
}

function jc_check_customer_nudge($customer_id)
{
	global $db;
	$nudge_debug = 0;
	//check db for nudge entries
	$nudge_query =  "SELECT
					  c.customers_email_address, n.*
					FROM
					  customers c
					INNER JOIN
					  nudges n
					ON
					  c.customers_nudge = n.nudges_id
				    WHERE
					  c.customers_id = {$customer_id}
				    AND
					  (n.nudge_expiration > unix_timestamp()
					OR
					  n.nudge_expiration IS NULL
					OR
					  n.nudge_expiration = '');";
	$nudge_query_result = $db->Execute($nudge_query);
	if(!empty($nudge_query_result->fields['nudge_category_ids_json']))
	{
		//build list from this array
		$commaList = $nudge_query_result->fields['nudge_category_ids_json'];
	}
	elseif(!empty($nudge_query_result->fields['nudge_master_category_id']))
	{
		//get all children from nudge_master_cat (TODO - build function)
		$commaList = jc_get_child_cat_from_parent($nudge_query_result->fields['nudge_master_category_id']);
	}
	else
	{
		return false;
	}
	switch($nudge_query_result->fields['nudges_id'])
	{
		case 1:
			$popup_text = "<div style='width:100% ; text-align:center ; font-size:1.3em'><span style='font-weight:bold ; font-family:Raleway'>Spending too much on helium?<br />Customers looking for something different?<br />We offer Everyday, Seasonal and Licensed Fill with Air Balloons</span></div><br />";
			$months = 12;
			break;
		
		default:
			$popup_text = "We noticed you haven't tried our schmancy new {$nudge_query_result->fields['name']}....  what gives?  are you too good for {$nudge_query_result->fields['name']}??";
			$months = 5;			
			break;
	}
	
	//loop through and check for 
	$nudge_ck_query =  "SELECT
						  o.orders_id, o.date_purchased, count(op.products_id)
						FROM
						  orders o
						LEFT JOIN
						  orders_products op
						ON
						  o.orders_id = op.orders_id
						LEFT JOIN
						  products_to_categories p2c
						ON
						  p2c.products_id = op.products_id
						WHERE
						  p2c.categories_id IN ({$commaList})
						AND
						  o.customers_id = {$customer_id}
						AND
						  o.date_purchased >= NOW() - INTERVAL {$months} MONTH
						GROUP BY o.orders_id;";
	$nudgeResult = $db->Execute($nudge_ck_query);
	if($nudge_debug)
	{
		echo "sql:$nudge_ck_query\n";
		echo '<pre>nudge';
		print_r($nudgeResult->fields);
		echo '</pre>';
		exit;
	}
	$popup_display = array();
	$popup_display['text'] = $popup_text;
	$popup_display['nudge_image'] = $nudge_query_result->fields['nudge_image'];
	$popup_display['nudge_link'] = $nudge_query_result->fields['nudge_link'];
	if($nudge_debug)
	{
		echo '<pre>popup_display';
		print_r($popup_display);
		echo '</pre>';
	}
	if(empty($nudgeResult->fields['orders_id']))
	{
		return $popup_display;
	}
	else
	{
		return false;
	}	
}

function jc_get_child_cat_from_parent($parent_id)
{
	global $db;
	$nudge_debug = 0;
	//round 1 = get all 2nd level children of parent
	$round1_query = "SELECT categories_id FROM categories WHERE parent_id = {$parent_id} AND categories_status = 1";
	$round1 = $db->Execute($round1_query);
	while (!$round1->EOF){
		$children[] = $round1->fields['categories_id'];
		$round1->moveNext();
	}
	if(sizeof($children) > 0)
	{
		//round 2 - get all 3rd level children of 2nd level cat
		if($nudge_debug)
		{
			echo '<pre>children1';
			print_r($children);
			echo '</pre>';
		}
		foreach($children as $child)
		{
			$subcat_query = "SELECT * FROM categories WHERE parent_id = {$child} AND categories_status = 1";
			$subcat_result = $db->Execute($subcat_query);
			$sub_cats = array();
			while (!$subcat_result->EOF){
				$children[] = $subcat_result->fields['categories_id'];
				$sub_cats[] = $subcat_result->fields['categories_id'];
				$subcat_result->moveNext();
			}
		}
		if(sizeof($sub_cats) > 0)
		{
			if($nudge_debug)
			{	
				echo '<pre>children2';
				print_r($children);
				echo '</pre>';
			}
			//round 3 - get all 4th level children of 3rd level cat
			foreach($sub_cats as $cat)
			{
				$subcat_query = "SELECT * FROM categories WHERE parent_id = {$cat} AND categories_status = 1";
				$subcat_result = $db->Execute($subcat_query);
				$sub_cats = array();
				while (!$subcat_result->EOF){
					$subcat_result->fields['categories_id'];
					$children[] = $subcat_result->fields['categories_id'];
					$sub_cats[] = $subcat_result->fields['categories_id'];
					$subcat_result->moveNext();
				}
			}
		}
		if($nudge_debug)
		{
			echo '<pre>children3';
			print_r($children);
			echo '</pre>';
		}
		$list = implode(', ', $children);
		$final_cat_list = rtrim($list, ', ');
		return $final_cat_list;
	}
	else
	{
		return $parent_id;
	}
}

function jc_reset_customer_nudge($customer_id)
{
	global $db;
	$nudge_reset_query = "UPDATE customers SET customers_nudge = 0 WHERE customers_id = {$customer_id}";
	if(!$nudge = $db->Execute($nudge_reset_query))
	{
		//log error
		return false;
	}
	else
	{
		return true;
	}
}