<?php
define('HEADING_TITLE', 'Create a New Customer');

define('TEXT_EMAIL_SUBJECT_NEW_ACCOUNT_CREATED', 'ALERT: a new customer has been added to your online store by an administrator.');
define('TEXT_EMAIL_MESSAGE_NEW_ACCOUNT_CREATED', 'This is an automated email from your Zen Cart store to notify you a new customer was created using the administrative interface: ' . "\n\n" . 'NOTE: Account has been created for [%s], by Zen Cart admin user %s.' . "\n\n" . 'If you did not initiate these changes, it is advisable that you validate the account and settings immediately.' . "\n\n" . 'If you are already aware of these changes, you can ignore this automated email.');

define('PULL_DOWN_DEFAULT', 'Please Choose Your Country');
define('PLEASE_SELECT', 'Please select ...');
define('TYPE_BELOW', 'Type a choice below ...');

define('TABLE_HEADING_PRIVACY_CONDITIONS', 'Privacy Statement');
define('TEXT_PRIVACY_CONDITIONS_DESCRIPTION', 'Please acknowledge you agree with our privacy statement by ticking the following box. The privacy statement can be read <a href="' . zen_href_link(FILENAME_PRIVACY, '', 'SSL') . '"><span class="pseudolink">here</span></a>.');
define('TEXT_PRIVACY_CONDITIONS_CONFIRM', 'I have read and agreed to your privacy statement.');
define('TABLE_HEADING_ADDRESS_DETAILS', 'Shipping Address');
define('TABLE_HEADING_BILLING_ADDRESS_DETAILS', 'Billing Address (leave blank if same as Shipping Address)');
define('TABLE_HEADING_PHONE_FAX_DETAILS', 'Additional Contact Details');
define('TABLE_HEADING_DATE_OF_BIRTH', 'Verify Your Age');
define('TABLE_HEADING_LOGIN_DETAILS', 'Login Details');
define('TABLE_HEADING_REFERRAL_DETAILS', 'Were You Referred to Us?');

define('ENTRY_COMPANY_TEXT', '');
define('ENTRY_GENDER_TEXT', '*');
define('ENTRY_FIRST_NAME_TEXT', '*');
define('ENTRY_LAST_NAME_TEXT', '*');
define('ENTRY_DATE_OF_BIRTH_TEXT', '* (eg. 05/21/1970)');
define('ENTRY_EMAIL_ADDRESS_TEXT', '*');
define('ENTRY_NICK', 'Forum Nick Name:');
define('ENTRY_NICK_TEXT', '*'); // note to display beside nickname input field
define('ENTRY_NICK_DUPLICATE_ERROR', 'That Nick Name is already being used. Please try another.');
define('ENTRY_NICK_LENGTH_ERROR', 'Please try again. Your Nick Name must contain at least ' . ENTRY_NICK_MIN_LENGTH . ' characters.');
define('ENTRY_STREET_ADDRESS_TEXT', '*');
define('ENTRY_SUBURB_TEXT', '');
define('ENTRY_POST_CODE_TEXT', '*');
define('ENTRY_CUSTOMERS_REFERRAL', 'Referral Code:');
define('ENTRY_CITY_TEXT', '*');
define('ENTRY_STATE_TEXT', '*');
define('ENTRY_STATE_ERROR_SELECT', 'Please select a state from the States pull down menu.');
define('JS_STATE_SELECT', '-- Please Choose --');
define('ENTRY_COUNTRY_TEXT', '*');
define('ENTRY_TELEPHONE_NUMBER_TEXT', '*');
define('ENTRY_FAX_NUMBER_TEXT', '');
define('ENTRY_NEWSLETTER_TEXT', '');
define('ENTRY_PASSWORD', 'Password:');
define('ENTRY_PASSWORD_ERROR', 'Your Password must contain a minimum of ' . ENTRY_PASSWORD_MIN_LENGTH . ' characters.');
define('ENTRY_PASSWORD_ERROR_NOT_MATCHING', 'The Password Confirmation must match your Password.');
define('ENTRY_PASSWORD_TEXT', '* (at least ' . ENTRY_PASSWORD_MIN_LENGTH . ' characters)');
define('ENTRY_PASSWORD_CONFIRMATION', 'Confirm Password:');
define('ENTRY_PASSWORD_CONFIRMATION_TEXT', '*');
define('ENTRY_PASSWORD_CURRENT', 'Current Password:');
define('ENTRY_PASSWORD_CURRENT_TEXT', '*');
define('ENTRY_PASSWORD_CURRENT_ERROR', 'Your Password must contain a minimum of ' . ENTRY_PASSWORD_MIN_LENGTH . ' characters.');
define('ENTRY_PASSWORD_NEW', 'New Password:');
define('ENTRY_PASSWORD_NEW_TEXT', '*');
define('ENTRY_PASSWORD_NEW_ERROR', 'Your new Password must contain a minimum of ' . ENTRY_PASSWORD_MIN_LENGTH . ' characters.');
define('ENTRY_PASSWORD_NEW_ERROR_NOT_MATCHING', 'The Password Confirmation must match your new Password.');
define('PASSWORD_HIDDEN', '--HIDDEN--');

define('FORM_REQUIRED_INFORMATION', '* Required information');
define('ENTRY_REQUIRED_SYMBOL', '*');