<?php
require_once('includes/application_top.php');
//check if logged in
$addr_debug = 0;
$is_logged_in = true;
$log_file = '/home/nikkisba/public_html/logs/address_check.log';
if(!$_POST['validate_address']) {
    zen_redirect(zen_href_link(FILENAME_DEFAULT));
    exit;
} else {
    $cleanArray = array();
    foreach($_POST as $pindex=>$pvalue) {
        $$pindex = htmlspecialchars($pvalue, ENT_QUOTES, 'UTF-8');
        $cleanArray[$pindex] = htmlspecialchars($pvalue, ENT_QUOTES, 'UTF-8');
    }
    $clean_json = json_encode($cleanArray,true);
    error_log("[".date('m-d-Y H:i:s'). "]".$clean_json."\n",3,$log_file);
    if($addr_debug) {
        echo $clean_json;        
    }
    if($cleanArray['validate_address']) {
        $state_name = zen_get_zone_code(223,$cleanArray['ajax_state'],0);
        //$temp_state_name = 'MD';
        //$temp_country_name = 'US';
        //echo 'key: '.MODULE_SHIPPING_UPSXML_RATES_ACCESS_KEY;
        require_once('/home/nikkisba/vendor/autoload.php');
        $address = new \Ups\Entity\Address();
        //$address->setAttentionName($get_address->fields['entry_firstname'] . ' ' .$get_address->fields['entry_lastname']);
        //$address->setBuildingName('');
        $address->setAddressLine1($cleanArray['ajax_addr']);
        if($get_address->fields['entry_suburb']) {
            $address->setAddressLine2($cleanArray['ajax_addr2']);
        }

        $address->setStateProvinceCode($state_name);
        $address->setCity($cleanArray['ajax_city']);
        $address->setCountryCode('US');
        $address->setPostalCode($cleanArray['ajax_postcode']);
        $xav = new \Ups\AddressValidation(MODULE_SHIPPING_UPSXML_RATES_ACCESS_KEY, MODULE_SHIPPING_UPSXML_RATES_USERNAME, MODULE_SHIPPING_UPSXML_RATES_PASSWORD);
        $xav->activateReturnObjectOnValidate(); //This is optional
        try {
            $response = $xav->validate($address, $requestOption = \Ups\AddressValidation::REQUEST_OPTION_ADDRESS_VALIDATION, $maxSuggestion = 15);
        } catch (Exception $e) {
            error_log("[".date('m-d-Y H:i:s'). "]error".print_r($err,true)."\n",3,$log_file);
            echo '<pre>err';
            print_r($e);
            echo '</pre>';
        }
        if ($response->noCandidates()) {
            error_log("[".date('m-d-Y H:i:s'). "]no candidates found\n",3,$log_file);
            return false;
            //TODO Do something clever and helpful to let the use know the address is invalid
        }
        $candidateAddresses = $response->getCandidateAddressList();
        if(sizeof($candidateAddresses) < 2) {
            error_log("[".date('m-d-Y H:i:s'). "]there is only one candidate, lets see if its any different than user input\n",3,$log_file);
            //there is only one candidate, lets see if its any different than user input
            if(strtoupper($candidateAddresses[0]->addressLine) == strtoupper($cleanArray['ajax_addr']) && strtoupper($candidateAddresses[0]->addressLine2) == strtoupper($cleanArray['ajax_addr2']) && strtoupper($candidateAddresses[0]->politicalDivision2) == strtoupper($cleanArray['ajax_city']) && strtoupper($candidateAddresses[0]->politicalDivision1) == strtoupper($state_name)) {
                //echo 'all fields match, nothing to update';
                error_log("[".date('m-d-Y H:i:s'). "]all fields match, nothing to update\n",3,$log_file);
                return false;
                exit;
            } /*else {
                echo "{$candidateAddresses[0]->addressLine} == {$cleanArray['ajax_addr']} && {$candidateAddresses[0]->addressLine2} == {$cleanArray['ajax_addr2']} && {$candidateAddresses[0]->politicalDivision2} == {$cleanArray['ajax_city']} && {$candidateAddresses[0]->politicalDivision1} == $state_name";
            }*/
        }
        foreach($candidateAddresses as $key=>$address) {
            if($address->addressLine2 ) {
                $show_addr_line_2 = true;
            }
            if($address->addressLine3 ) {
                $show_addr_line_3 = true;
            }
        }
        //if ($response->isAmbiguous()) {
        
          echo '<h3>We have verified your address and have the following suggestions:</h3>';

          //echo '<form method="POST" name="address-validation-form" id="address-select-form">';
          
          
          echo '<input type="hidden" name="main_page" value="address_book_process">';
          echo '<input type="hidden" name="" value="'.$_SESSION['sendto'].'">';
          //echo '<div style="text-align:center"><div class="address_candidate_table" width="80%">';
          echo '<table style="border:thin solid #666 ; width:100% ; text-align:left"><tr style="font-weight:bold ; text-align:left"><th></th><th style="min-width:30% ; text-align:left">Address Line 1</th>';
          if($show_addr_line_2) {
              echo '<th>Address Line 2</th>';
          }
          if($show_addr_line_3) {
            echo '<th>Address Line 3</th>';
          }
          echo '<th style="text-align:left">City</th><th style="text-align:left">State</th><th style="text-align:left">Postal Code</th></tr>';
          //
          foreach($candidateAddresses as $key=>$address) {
            $display_key = $key +1;
            error_log("[".date('m-d-Y H:i:s'). "]candidate $display_key of ".sizeof($candidateAddresses)." found: ".json_encode($address)."\n",3,$log_file);
            $zone_id = zen_get_zone_id(223,$address->politicalDivision1);
            /*echo '<form id="address-details-'.$key.'-form">';
            echo '<input type="hidden" name="street_address" value="'.$address->addressLine.'">';
            echo '<input type="hidden" name="suburb" value="'.$address->addressLine2.'">';
            echo '<input type="hidden" name="city" value="'.$address->politicalDivision2.'">';
            echo '<input type="hidden" name="state" value="'.$address->politicalDivision1.'">';
            echo '<input type="hidden" name="postcode" value="'.$address->postcodePrimaryLow . '-'. $address->postcodeExtendedLow.'">';*/
            //draw form, give button for each option
            echo '<tr class="main">';
            //echo '<td><input type="radio" name="address-select-radio" value="'.$key.'" /></td>';
            echo '<td><input type="radio" name="address-selector" value="'.$key.'"></td>';
            echo '<td id="addr-'.$key.'">' . $address->addressLine . '</td>';
            if($address->addressLine2) {
              echo '<td id="addr2-'.$key.'">' . $address->addressLine2 . '</td>';
            }
            if($address->addressLine3) {
              echo '<td id="addr3-'.$key.'">' . $address->addressLine3 . '</td>';
            }
            echo '<td id="poliDiv2-'.$key.'">' . $address->politicalDivision2 . '</td>';
            echo '<input type="hidden" name="zone_id-'.$key.'" value="'.$zone_id.'">';
            echo '<td id="poliDiv1-'.$key.'">' . $address->politicalDivision1 . '</td>';
            echo '<td id="postcode-'.$key.'">' . $address->postcodePrimaryLow . '-'. $address->postcodeExtendedLow.'</td>';
            echo '</tr>';
            //print_r($address);  
            //Present user with list of candidate addresses so they can pick the correct one        
          }
          //echo '<span><input type="submit" id="select-addr-button" value="Select This Address"></span>';
          //echo '</form>';
          echo '</tr></table>';
          echo '</div>';
        //}
    }
}

?>

